#!/usr/bin/perl -T

use strict;

use CGI::Carp qw(fatalsToBrowser warningsToBrowser);
use CGI qw/:standard -no_xhtml/;    # load standard CGI routines
warningsToBrowser(1);
BEGIN { warningsToBrowser(1); }     # want warning as as HTML comments

# security measures (next to -T)
$CGI::POST_MAX=1024; # max 1K posts
$CGI::DISABLE_UPLOADS = 1; # no uploads

my $error = cgi_error();
if ($error) {
   print header(-status=>$error),
   start_html('Problems'),
   h2('Request not processed'),
   strong($error);
   exit 0;
}

no strict;                              # not for string to function...
sub demo_functie
{
    my $func_name = shift;
    print "<tr><td>$func_name( )</td><td>"
    . (&$func_name() || "<i>not defined</i>")
    . "</td></tr>\n";
}
use strict;

my $mycookie = escapeHTML(cookie('meer_data') || 'No cookie set');

my $now = gmtime(time());
my $newcookie = cookie(-name => 'meer_data',
                       -value => $now,
                       -path => '/cgi');
#  this is default:    -domain => '.keesmoerman.nl');

print header(-cookie=>$newcookie),        # create the HTTP header, with new cookie
      start_html('Meer_data CGI demo'),   # start the HTML
      h1("Demonstratie van enkele CGI functies\n"),
      h2("Argumenten overdracht"),
      p("De aan de cgi-aanroep meegegevens argument-lijst met behulp
      van de Dump() functie (handig bij foutzoeken). Je kan hier zelf
      argumenten testen, door ze achter de URL van het script te
      plaatsen, bijvoorbeeld '....meer_data/cgi<b>?a=1&b=hello</b>':\n"),
      Dump(),
      p("Functies voor access van gebruiker-gegevens\n"),
      '<table border="1">';

for my $name ('path_info', 'remote_host', 'script_name', 'referer',
              'user_agent', 'request_method', 'Accept',
              'user_name', 'server_name', 'server_port')
{ demo_functie($name); }

print "</table>";

print h2("Cookie handling"),
      p("Het volgende gedeelte test cookie afhandeling\n"),
      p("De huidige tijd (op de server, in GMT zone) is '$now', deze waarde
         zal in een cookie genaamd 'meer_data' bewaard gaan worden.\n"),
      p("De vorige waarde van 'meer_data' was: '$mycookie'");

print end_html();                       # end the HTML

#end of script

